//----------------------------------------------------------------------------//
//- CapSteuerCodes.pas -------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dient zum Ausdrucken der Steuer-Strichcodes                                //
//----------------------------------------------------------------------------//

unit CapSteuerCodes;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, SysUtils, Messages, Classes, Graphics, Controls, StdCtrls, ExtCtrls,
  Forms, QuickRpt, QRCtrls, CaoFormat, CamConst;

//------------------------------------------------------------------------------

type
  TCapQrSteuerCodes = class(TQuickRep)
    m_BndCodes            : TQRStringsBand;
    m_BndHeader: TQRBand;
    QRLabel1: TQRLabel;
    m_LblQrVerkaufAbschlussCode: TQRLabel;
    m_LblQrVerkaufAbschluss: TQRLabel;
    m_LblQrArtikelCode: TQRLabel;
    m_LblQrArtikel: TQRLabel;
    m_LblQrQuittungCode: TQRLabel;
    m_LblQrQuittung: TQRLabel;
    m_LblQrAnbieterCode: TQRLabel;
    m_LblQrAnbieter: TQRLabel;
    QRShape1: TQRShape;

    //--------------------------------------------------------------------------

    procedure QuickRepBeforePrint(Sender         : TCustomQuickRep;
                                  var PrintReport: Boolean);

  //----------------------------------------------------------------------------

  private
    m_obFormat: TCaoFormat;

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------

  end; // TCapQrSteuerCodes

//------------------------------------------------------------------------------

var
  CapQrSteuerCodes: TCapQrSteuerCodes;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.DFM}

//------------------------------------------------------------------------------

procedure TCapQrSteuerCodes.QuickRepBeforePrint(Sender         : TCustomQuickRep;
                                                var PrintReport: Boolean);
begin
  m_LblQrVerkaufAbschlussCode.Caption :=
    m_obFormat.FormatBarCode(c_iOrderVerkaufBeenden);
  m_LblQrQuittungCode.Caption         :=
    m_obFormat.FormatBarCode(c_iOrderQuittungDrucken);
  m_LblQrAnbieterCode.Caption         :=
    m_obFormat.FormatBarCode(c_iOrderAnbieterErfassen);
  m_LblQrArtikelCode.Caption          :=
    m_obFormat.FormatBarCode(c_iOrderArtikelErfassen); 
end; // TCapQrSteuerCodes.QuickRepBeforePrint

//------------------------------------------------------------------------------

end. // CapSteuerCodes
